﻿if (typeof QIShop == 'undefined')
	QIShop = {};

QIShop.paymentShipment = {};
QIShop.deliveryData = {};
QIShop.transportLocations = {};

(function() {
	const s = QIShop;

	s.prepareAjaxQS = function(page, params)
    {
		const paramsIsObj = typeof (params) === 'object';
		const paramsIsStr = typeof (params) === 'string';

		if (page == null)
			page = s.currentPage;

		const qs = {};
		qs['page'] = page;
		qs['goodsGroup'] = s.goodsGroup;
		qs['ax_targetEvntFld'] = QIPortalAPI.targetEventField;
		const sort = $.getUrlVar('sort');
		if (sort)
		{
			qs['sort'] = sort;
		}

		let fullText = $.getUrlVar('FullText');
		if (!fullText)
			fullText = $.getUrlVar('fullText');
		
		if (fullText)
		{
			qs['fullText'] = fullText;
		}

		const urlVars = $.getUrlVars();
		for (let urlVar in urlVars)
		{
			if (urlVars.hasOwnProperty(urlVar))
			{
				if (urlVar.startsWith('flt_'))
					qs[urlVar] = urlVars[urlVar];
			}
		}
		
		if (paramsIsObj)
		{
		    for (let tmp in params)
		    {
		        if (params.hasOwnProperty(tmp))
		        {
		            qs[tmp] = params[tmp];
		        }
		    }
		}

		const result = $.param(qs);

		if (paramsIsStr)
		{
			qs.push += '&' + ((params.startsWith('?') || params.startsWith('&')) ? params.substr(1) : params);
		}
		
		return result;
    }

	s.getNextPage = function()
	{
		if (!s.currentPage)
		{
			let sPage = $.getUrlVar('page');
			if ((! sPage) || (isNaN(sPage)))
			    sPage = '1';
			s.currentPage = parseInt(sPage);
		}

		const qs = s.prepareAjaxQS(s.currentPage + s.pagesRead);

		QIPortalAPI.getAjaxData('GoodsListNextPage', qs, function(name, data)
		{
			if ((name === 'GoodsListNextPage') && ((s.currentPage + s.pagesRead) > 1))
			{
				//QIShop.currentPage++;
				s.pagesRead++;
				let dynContentComment = $.getAllComments('.qishop-GoodsListModuleContent', 'GoodsListDynamicContent');
				if (dynContentComment.length === 0)
					dynContentComment = $.getAllComments('.contentPanel', 'GoodsListDynamicContent');
				dynContentComment.before(data);
				if (History)
					History.pushState({ pagesRead: s.pagesRead, rand: Math.random() }, '', $.updateQueryStringParam('pageCnt', s.pagesRead));
				s.checkNextPageButton();
				return true;
			}
			
			return false;
		});
		
		return false;
	};
	
	s.getGoodsListItems = function(page, queryParams, params)
	{
		//queryParams = queryParams || {};
		//queryParams['fullDataList'] = '1';

		const qs = s.prepareAjaxQS(page, queryParams);

		QIPortalAPI.getAjaxData('GoodsListItems', qs, function (name, data)
		{
			let comment;
			if (name === 'GoodsListItems')
			{
				s.currentPage = page;
				s.pagesRead = 1;

				let i;
				const begin = $.getAllComments('.qishop-GoodsListModuleContent', 'GoodsListTemplateItems'),
					end = $.getAllComments('.qishop-GoodsListModuleContent', 'GoodsListTemplateItemsEnd'),
					nodes = [],
					keepComments = [],
					beginNode = begin[0];
				let next = beginNode.nextSibling;
				const prnt = beginNode.parentNode;

				while ((next) && (next !== end[0]))
		        {
		            if (!((next.nodeType === 8) && (next.nodeValue.startsWith('GoodsList'))))
		            {
						nodes.push(next);
						const comments = $.getAllComments(next);
						if (comments.length > 0)
						{
							for (i = 0; i < comments.length; i++)
							{
								comment = comments[i];
								if (comment.nodeValue.startsWith('GoodsList'))
									keepComments.push(comment);
							}
						}
					}

					next = next.nextSibling;
				}

				for (i = keepComments.length - 1; i >= 0; i--)
				{
					comment = keepComments[i];
					prnt.insertBefore(comment, beginNode.nextSibling);
				}
				
				for (i = 0; i < nodes.length; i++)
				{
					prnt.removeChild(nodes[i]);
				}
				
				begin.after(data);
				
				if (History)
					History.pushState({ page: page, rand: Math.random() }, '', $.updateQueryStringParam({ page: page, pageCnt: null }));
			return true;
		    }
		
		    return false;
		});
		
		return false;
	};
	
	s.checkNextPageButton = function()
	{
		try
		{
			if (s.currentPage + s.pagesRead > s.totalPageCount)
				$(".goodsList-nextPage").hide();
		}
		catch (e) { }

	};
})();


(function()
{
	const ps = QIShop.paymentShipment;

	ps.compatibility = true;

	ps.selectedShipmentElemId = null;
	ps.selectedPaymentElemId = null;

	ps.init = function(options)
	{
		if ((!ps.definition) || (ps.definition.length === 0))
			return;

		const code = [];

		switch (options.displayType)
		{
			case '':
			case 'combobox':
			case 'listbox':
			{
				createSelectItems(code, options);
				break;
			}
			case 'radio', 'radiobutton':
			{
				createRadioButtonItems(code, options);
				break;
			}
		}

		$('#' + options.parentControl).html(code.join('\n'));
	};

	function getSelectedShipmentId()
	{
		const selShipmentId = $('#' + ps.selectedShipmentElemId).val();
		if (selShipmentId == '')
			return ps.definition[0].id;

		for (let i = 0; i < ps.definition.length; i++)
		{
			const id = ps.definition[i].id;
			if (id == selShipmentId)
				return id;
		}

		return ps.definition[0].id;
	}

	function getSelectedPaymentId(shipment)
	{
		const selPaymentId = $('#' + ps.selectedPaymentElemId).val();
		const payments = shipment.payments;
		if ((!payments) || (payments.length == 0))
			return '';

		if (selPaymentId == '')
		{
			return ps.payments[payments[0]].id;
		}

		for (let i = 0; i < payments.length; i++)
		{
			const id = ps.payments[payments[i]].id;
			if (id == selPaymentId)
				return id;
		}

		return ps.payments[payments[0]].id;
	}

	function createSelectItems(code, options)
	{
		let txt;
		if ((!ps.definition) || (ps.definition.length == 0))
			return;

		let i, def, size = '';
		const what = options.what;
		let selected, shipment = null, payment = null;
		let selShipmentId = getSelectedShipmentId();
		if (selShipmentId == '')
			selShipmentId = ps.definition[0].id;

		if (options.displayType == 'listbox')
			size = ' size="' + (options.rows || 4) + '"';

		if ((what == 0) || (what == 2))
		{
			if (ps.compatibility)
				code.push('<span class="Normal ShipmentsList">');
			else
				code.push('<div class="Normal ShipmentSelection">');

			code.push('<select id="shipmentSelection" class="Normal ShipmentSelection"' + size + ' onchange="QIShop.paymentShipment.shipmentSelChanged(this);">');

			for (i = 0; i < ps.definition.length; i++)
			{
				selected = '';
				def = ps.definition[i];
				if (def.id == selShipmentId)
				{
					shipment = def;
					selected = ' selected="selected"';

					showTLSelection(def);
				}

				txt = def.text;
				if (def.price)
				{
					if (def.currency)
					{
						txt += ' (' + def.price + ' ' + def.currency + ')';
					}
					else {
						txt += ' ' + def.price;
					}
				}
				
				code.push('<option data-id="' + def.dataId + '" value="' + i + '"' + selected + '>' + txt + '</option>');
			}

			code.push('</select>');
			code.push(ps.compatibility ? '</span>' : '</div>');
		}

		if (shipment == null)
		{
			//shipment = ps.definition[0];
			for (i = 0; i < ps.definition.length; i++)
			{
				def = ps.definition[i];
				if (def.id == selShipmentId)
				{
					shipment = def;
					break;
				}
			}
		}

		ps.selectedShipment = shipment;
		$('#' + ps.selectedShipmentElemId).val(shipment.id);
		ps.selectedPayment = null;

		if ((what == 1) || (what == 2))
		{
			if (ps.compatibility)
				code.push('<span class="Normal PaymentsList">');
			else
				code.push('<div class="Normal PaymentSelection">');

			let selPaymentId = getSelectedPaymentId(ps.selectedShipment);
			const payments = ps.selectedShipment.payments;
			if ((payments) && (payments.length > 0))
			{
				code.push('<select id="paymentSelection" class="Normal PaymentSelection"' + size + ' onchange="QIShop.paymentShipment.paymentSelChanged(this);">');

				if (selPaymentId == '')
					selPaymentId = ps.payments[payments[0]].id;

				for (i = 0; i < payments.length; i++)
				{
					selected = '';
					def = ps.payments[payments[i]];
					if (def.id == selPaymentId)
					{
						payment = def;
						selected = ' selected="selected"';
					}

					txt = def.text;
					if (def.currency)
					{
						txt += ' (' + def.price + ' ' + def.currency + ')';
					}
					else
					{
						txt += ' ' + def.price;
					}

					code.push('<option data-id="' + def.dataId + '" value="' + i + '"' + selected + '>' + txt + '</option>');
				}
				code.push('</select>');

				if (payment == null)
					payment = ps.payments[payments[0]];

				ps.selectedPayment = payment;
				$('#' + ps.selectedPaymentElemId).val(ps.selectedPayment.id);
			}

			code.push(ps.compatibility ? '</span>' : '</div>');
		}
	}

	ps.shipmentSelChanged = function(select)
	{
		const shipment = ps.definition[select.selectedIndex];
		ps.selectedShipment = shipment;
		const selPaymentId = getSelectedPaymentId(ps.selectedShipment);
		let payment = null;

		showTLSelection(shipment);

		const code = [];
		const payments = shipment.payments;
		if ((payments) && (payments.length > 0))
		{
			for (let i = 0; i < payments.length; i++)
			{
				const def = ps.payments[payments[i]];
				let selected = '';
				if (def.id === selPaymentId)
				{
					payment = def;
					selected = ' selected="selected"';
				}

				let txt = def.text;
				if (def.price)
				{
					if (def.currency)
					{
						txt += ' (' + def.price + ' ' + def.currency + ')';
					}
					else
					{
						txt += ' ' + def.price;
					}
				}

				code.push('<option data-id="' + def.dataId + '" value="' + i + '"' + selected + '>' + txt + '</option>');
			}

			if (payment == null)
				payment = ps.payments[payments[0]];

			$('#' + ps.selectedPaymentElemId).val(payment.id);
		}

		$('#paymentSelection').html(code.join('\n'));

		$('#' + ps.selectedShipmentElemId).val(shipment.id);
	};

	ps.paymentSelChanged = function(select)
	{
		const payment = ps.payments[ps.selectedShipment.payments[select.selectedIndex]];

		ps.selectedPayment = payment;

		$('#' + ps.selectedPaymentElemId).val(payment.id);
	};

	function createRadioButtonItems(code, options)
	{
		if ((!ps.definition) || (ps.definition.length == 0))
			return;

		let i, def, click;
		const what = options.what;
		let selected, shipment = null, payment = null;
		let selShipmentId = getSelectedShipmentId();
		if (selShipmentId == '')
			selShipmentId = ps.definition[0].id;

		if ((what == 0) || (what == 2))
		{
			if (ps.compatibility)
				code.push('<span id="shipmentSelection" class="Normal ShipmentsList">');
			else
				code.push('<div id="shipmentSelection" class="Normal ShipmentSelection">');

			for (i = 0; i < ps.definition.length; i++)
			{
				selected = '';
				def = ps.definition[i];
				if (def.id == selShipmentId)
				{
					shipment = def;
					selected = ' checked="checked"';

					showTLSelection(def);
				}

				let txt = '<span class="shipmentName">' + def.text + '</span>';
				if (def.price)
				{
					txt += ' <span class="shipmentPrice">';
					if (def.currency)
					{
						txt += ' (' + def.price + ' ' + def.currency + ')';
					}
					else
					{
						txt += ' ' + def.price;
					}
					txt += '</span>';
				}

				click = ' onclick="QIShop.paymentShipment.shipmentRBClick(\'' + i + '\')"';
				code.push('<div class="ShipmentRadioButton"><input type="radio" data-id="' + def.dataId + '" value="' + i + '" id="shpmntSel_' + i + '" name="shipmentSelection"' + selected + click + '/><label for="shpmntSel_' + i + '">' + txt + '</label></div>');
			}

			code.push(ps.compatibility ? '</span>' : '</div>');
		}

		if (shipment == null)
		{
			//shipment = ps.definition[0];
			for (i = 0; i < ps.definition.length; i++)
			{
				def = ps.definition[i];
				if (def.id == selShipmentId)
				{
					shipment = def;
					break;
				}
			}
		}

		ps.selectedShipment = shipment;
		$('#' + ps.selectedShipmentElemId).val(shipment.id);
		ps.selectedPayment = null;

		if ((what == 1) || (what == 2))
		{
			if (ps.compatibility)
				code.push('<span id="paymentSelection" class="Normal PaymentList">');
			else
				code.push('<div id="paymentSelection" class="Normal PaymentSelection">');

			let selPaymentId = getSelectedPaymentId(ps.selectedShipment);
			const payments = ps.selectedShipment.payments;
			if ((payments) && (payments.length > 0))
			{
				if (selPaymentId == '')
					selPaymentId = ps.payments[payments[0]].id;

				for (i = 0; i < payments.length; i++)
				{
					selected = '';
					def = ps.payments[payments[i]];
					if (def.id === selPaymentId)
					{
						payment = def;
						selected = ' checked="checked"';
					}

					let txt = '<span class="paymentName">' + def.text + '</span>';
					if (def.price)
					{
						txt += ' <span class="paymentPrice">';
						if (def.currency)
						{
							txt += ' (' + def.price + ' ' + def.currency + ')';
						}
						else
						{
							txt += ' ' + def.price;
						}
						txt += '</span>';
					}

					click = ' onclick="QIShop.paymentShipment.paymentRBClick(\'' + i + '\')"';
					code.push('<div class="PaymentRadioButton"><input data-id="' + def.dataId + '" type="radio" value="' + i + '" id="paymentSel_' + i + '" name="paymentSelection"' + selected + click + '/><label for="paymentSel_' + i + '">' + txt + '</label></div>');
				}
				if (payment == null)
					payment = ps.payments[payments[0]];

				ps.selectedPayment = payment;
				$('#' + ps.selectedPaymentElemId).val(ps.selectedPayment.id);
			}

			code.push(ps.compatibility ? '</span>' : '</div>');
		}
	}

	ps.shipmentRBClick = function(index)
	{
		const shipment = ps.definition[index];
		ps.selectedShipment = shipment;
		const selPaymentId = getSelectedPaymentId(ps.selectedShipment);
		let payment = null;

		showTLSelection(shipment);

		const code = [];
		const payments = shipment.payments;
		if ((payments) && (payments.length > 0))
		{
			for (let i = 0; i < payments.length; i++)
			{
				const def = ps.payments[payments[i]];
				let selected = '';
				if (def.id === selPaymentId)
				{
					payment = def;
					selected = ' checked="checked"';
				}

				let txt = '<span class="paymentName">' + def.text + '</span>';
				if (def.price)
				{
					txt += ' <span class="paymentPrice">';
					if (def.currency)
					{
						txt += ' (' + def.price + ' ' + def.currency + ')';
					}
					else
					{
						txt += ' ' + def.price;
					}
					txt += '</span>';
				}

				const click = ' onclick="QIShop.paymentShipment.paymentRBClick(\'' + i + '\')"';
				code.push('<div class="PaymentRadioButton"><input type="radio" data-id="' + def.dataId + '" value="' + i + '" id="paymentSel_' + i + '" name="paymentSelection"' + selected + click + '/><label for="paymentSel_' + i + '">' + txt + '</label></div>');
			}

			if (payment == null)
				payment = ps.payments[payments[0]];

			$('#' + ps.selectedPaymentElemId).val(payment.id);
		}

		$('#paymentSelection').html(code.join('\n'));

		$('#' + ps.selectedShipmentElemId).val(shipment.id);
	};

	ps.paymentRBClick = function(index)
	{
		const payment = ps.payments[ps.selectedShipment.payments[index]];
		ps.selectedPayment = payment;

		$('#' + ps.selectedPaymentElemId).val(payment.id);
	};

	function showTLSelection(def)
	{
		let tl = QIShop.transportLocations;
		if (! tl.options)
			return;

		let opt = tl.options;

		const tlSel = $('#' + ((opt.elemId) || 'tlSelection'));

		$('[id^=TransportLocation]').removeAttr('value');

		if (ps.nextStepId)
		{
			$('#' + ps.nextStepId).prop('disabled', '');
		}

		if (def.tpId == '')
		{
			tlSel.hide();
			return;
		}

		if (ps.nextStepId)
		{
			$('#' + ps.nextStepId).prop('disabled', 'disabled');
		}

		tlSel.show();
		if (!tl.isCreated)
		{
			tl.createGrid(def.tpId);
			tl.isCreated = true;
		}
		else
		{
			const pData = tl.getGridPostData(opt);
			pData.tpId = def.tpId;
			jQuery('#' + (opt.tableElement || 'tlSelectionGrid')).trigger('reloadGrid');
		}

	}


	const dd = QIShop.deliveryData;
	dd.items = [];
	dd.init = function(checked)
	{
		if (dd.hasTl)
		{
			$('[id^=delivery_]').hide();
		}
		else
		{
			const chBox = $('#delivery_sameAddress');
			if (chBox.length === 0)
				return;

			chBox.on('change',
				function()
				{
					dd.change(chBox.prop('checked'));
				});

			if ((checked) && (!chBox.prop('checked')))
				chBox.prop('checked', checked).trigger("change");
		}
	};

	dd.change = function(checked)
	{
		let item;
		let itemName;
		const div = $('#delivery_deliveryAddress');
		if (checked)
		{
			div.hide();
			for (itemName in dd.items)
			{
				if (itemName.substring(0, 1) === '#')
				{
					item = dd.items[itemName];
					item.last = $(itemName).val();
					$(itemName).val('');
				}
			};
		}
		else
		{
			div.show();

			for (itemName in dd.items)
			{
				if (itemName.substring(0, 1) === '#')
				{
					item = dd.items[itemName];
					if (item.last)
						$(itemName).val(item.last);
				}
			}
		}
	};
})();

$(function ()  // document ready
{
    if (QIPortalAPI.ajaxEnabled)
    {
        QIShop.checkNextPageButton();
    }
});
